 /*
  * UAE - The Un*x Amiga Emulator
  *
  * Joystick emulation code for OS/2
  *
  * Copyright 1997 Bernd Schmidt
  */
#define INCL_DOSFILEMGR         // include needed for DosOpen call
#define INCL_DOSDEVICES         // include needed for DosDevIOCtl call
#define INCL_DOSDEVIOCTL        // include needed for DosDevIOCtl call
#include <os2.h>
#include "joyos2.h"

#include "sysconfig.h"
#include "sysdeps.h"

#include "config.h"
#include "options.h"
#include "memory.h"
#include "custom.h"
#include "joystick.h"


// #include <stdio.h>              // included needed for printf support

JOYSTICK_STATUS stick;             // joystick readings
int nr_joysticks;

void read_joystick(int nr, unsigned int *dir, int *button)
{
 int left = 0, right = 0, top = 0, bot = 0;
  *dir = *button = 0;

  JoystickValues(&stick);          // returns the values of the joysticks

//  dataLen = sizeof(gameStatus);
//  rcj = DosDevIOCtl(hGame, IOCTL_CAT_USER, GAME_GET_STATUS, NULL, 0, NULL, &gameStatus, dataLen, &dataLen);
  if (nr==0) {
    if (stick.Joy1X == -1)
      left = 1;
    else if (stick.Joy1X == 1)
      right = 1;
    if (stick.Joy1Y == -1)
      top = 1;
    else if (stick.Joy1Y == 1)
      bot = 1;
    if (stick.Joy1A)
      *button += 1;
    if (stick.Joy1B)
      *button += 2;
    if ((*button) == 3) *button = 4;
  } else {
  }
  if (left) top = !top;
  if (right) bot = !bot;
  *dir = bot | (right << 1) | (top << 8) | (left << 9);
}

void init_joystick(void)
{
   if (JoystickInit(0))
      printf("Joystick calibration info loaded\n");
   else
      printf("Joystick calibration info defaulted\n");

   if (JoystickRange(-1, 1))
      printf("Joystick Range of -1 to 1 loaded\n");
   else
      printf("Joystick Range of -1 to 1 defaulted\n");

   if (JoystickOn())
   {
     printf("Unable to open joystick port\n");
     nr_joysticks = 0;
     return;
   }
   nr_joysticks = 2;
//   printf("%d Joysticks found\n",nr_joysticks);
}

void close_joystick(void)
{
  if (JoystickOff())
     printf("Joystick Port closed\n");
  else
     printf("Problem closing joystick port\n");

  if (JoystickSaveCalibration())
     printf("Calibration information saved!\n");
  else
     printf("Warning - was not able to save calibration information!\n");
  nr_joysticks = 0;
}

